classdef class_REVS_vehicle
    %class_REVS_vehicle
    %	Vehicle description class for REVS model for single axle drive
    
    properties
        
        name;							% Vechicle Description
        class;							% Vehicle Type Specifier
        fuel;							% Vehicle Fuel Specifier - Specified via class_REVS_fuel
        
        chassis = struct(	'mass_static_kg',		[],	... % Vehicle chassis description ( mass & roadload )
            'mass_dynamic_kg',		[],	...
            'coastdown_A_N',		[],	...
            'coastdown_B_Npms',		[],	...
            'coastdown_C_Npms2',	[], ...
            'speed_limit_mps',		inf);
        
        drive_axle1 = class_REVS_drive_axle;	% Drive Axle Definition Class
        
        max_brake_force_N;			% Total combined braking torque of all axles
        
    end
    
    methods
        
        function val = get.max_brake_force_N(obj)
            val = REVS_class_default( obj.max_brake_force_N , obj.chassis.mass_static_kg * 9.8 * 1.75);  % changed from 2.0 to 1.4 for REVS1 compatible brake gain and alternator regen...
        end
        
        
        function val = get.drive_axle1( obj )
            
            %Set axle parameters that require vehicle level inputs
            val = obj.drive_axle1;
            
            val.brake.max_torque_Nm = REVS_class_default( val.brake.max_torque_Nm, obj.max_brake_force_N * val.brake.proportion_norm * val.tire.radius_m);
            
            val.tire.wheel_slip_torque_Nm = REVS_class_default( val.tire.wheel_slip_torque_Nm, obj.chassis.mass_static_kg * val.tire.vehicle_weight_norm * 9.81 * val.tire.radius_m);
            
        end
    end
    
end

